#!/usr/bin/env python3
####################################################################
# monitor SR1 status
# switch between 2 configs
# generate webserver
#
from tkinter import *
from tkinter import messagebox
import tkinter as tk
import threading
import time

from sr1_codes import sc,cmdstat,names_mod,noval,IP_address
from sr1_codes import get_value,set_config,check_conn,is_integer


class RepeatedTimer(object):
  def __init__(self, interval, function, *args, **kwargs):
    self._timer = None
    self.interval = interval
    self.function = function
    self.args = args
    self.kwargs = kwargs
    self.is_running = False
    self.is_active = True
    self.start()

  def _run(self):
    self.function(*self.args, **self.kwargs)
    self.is_running = False
    self.start()

  def start(self):
    if (not self.is_running) and self.is_active:
      self._timer = threading.Timer(self.interval, self._run)
      self._timer.daemon=True
      self._timer.start()
      self.is_running = True

  def stop(self):
    self._timer.cancel()
    self.is_active = False
#    self.is_running = False

  def runs(self):
    return self.is_running

config_set=''
wsrv=None
def setup_gui():
  global ventry,wsrv
  ventry=[]

  def handle_config():
    global config_set
    config_set=varconf.get()+1
    set_config(config_set)
  
  def handle_websrv():
    global wsrv
    websrv_set=varwbsr.get()+1
    if websrv_set==2:
      wsrv=add_web(eoval)
    if websrv_set==1:
      wsrv.stop()
      wsrv=None

  wnd = tk.Tk()
  wnd.title('Satpy selector')
  frame1=Frame(wnd)
  m=0
  for n in cmdstat:
    slabel=Label(frame1,text=n[1],width=9,anchor=W)
    ventry.append(Entry(frame1,font=('Arial', 12, 'bold'),width=9))
    slabel.grid(column=1,row=m)
    ventry[m].grid(column=2,row=m)
    m+=1
  frame1.pack(side=tk.TOP)


  frame2=Frame(wnd)
  varconf = IntVar()
  varwbsr = IntVar()
  
  clabel=Label(frame2,text='Config.',width=9,anchor=W)
  rb1=Radiobutton(frame2,text="1",value=0,variable=varconf,command=handle_config)
  rb2=Radiobutton(frame2,text="2",value=1,variable=varconf,command=handle_config)

  frame3=Frame(wnd)
  wsb=Checkbutton(frame3,text='Webserver',variable=varwbsr,command=handle_websrv)

  clabel.pack(side='left')
  rb1.pack(side='left')
  rb2.pack(side='left')
  wsb.pack(side='left')

  frame2.pack()
  frame3.pack()

  val1=get_value(sc.code_config1)
  val2=get_value(sc.code_config2)
  if is_integer(val1):
    if int(val1)==1:
      rb2.invoke()
    else:
      rb1.invoke()
  return wnd

lmargl=-999
lmargh=-999
eoval=[]
def get_val():
  global ventry,lmargl,lmargh,eoval
  oval=[]
  for n in cmdstat:
    cmd=sc.base_oid_rx1+'.'+n[0]
    if n[1]=='LNB':
      nn=n[0].replace('?',str(config_set))
      cmd=sc.base_oid_rx1+'.'+nn

    val=get_value(cmd)

    if n[1]=='LNB':
      if is_integer(val):
        if int(val)==2:
          val='Pol. = H'
        elif int(val)==1:
          val='Pol. = V'
      
    if n[1]==names_mod[0]:
      if is_integer(val):
        modcod=int(val)
      else:
        modcod=0
    if n[1]==names_mod[1] and modcod==12:
      lmargl=val
    if n[1]==names_mod[2] and modcod==18:
      lmargh=val

    if n[1]==names_mod[0]:
      if modcod==18:
        val='16apsk 2/3'
      elif modcod==12:
        val='8psk 3/5'
      else:
        val='?'+str(modcod)+'?'

    if n[1]==names_mod[1]:
      if lmargl==-999:
        val=noval
      else:
        val=lmargl
    if n[1]==names_mod[2]:
      if lmargh==-999:
        val=noval
      else:
        val=lmargh

    sval=n[2](val)
    xoval=[]
    xoval.append(n[1])
    xoval.append(sval)
    oval.append(xoval)
#    oval.append(sval)

  for u in range(0,len(oval)):
    ventry[u].delete(0,END)
    ventry[u].insert(0,"{:s}".format(str(oval[u][1])))

  eoval=oval

import threading
import time
from http.server import ThreadingHTTPServer, BaseHTTPRequestHandler

serverPort = 8080
# dit geeft: unsupported method ('GET')
class MyServer2(BaseHTTPRequestHandler):
    def do_GET(self):
        res=eoval
        self.send_response(200)
        self.send_header("Content-type", "text/html")
        self.end_headers()
        self.wfile.write(bytes("<html><head><title>TEST</title></head>", "utf-8"))
        self.wfile.write(bytes("<body>", "utf-8"))
        self.wfile.write(bytes("<table border=1>", "utf-8"))
        for val in eoval:
          self.wfile.write(bytes("<TD><font size=5>%s<TD><font size=5>%s" % (val[0],val[1]), "utf-8"))
          self.wfile.write(bytes("</TR><TR>", "utf-8"))
        self.wfile.write(bytes("</table>", "utf-8"))

        for val in eoval:
          if val[0]=='SNR':
            self.wfile.write(bytes("<font size=20><P>%s = %s" % (val[0],val[1]), "utf-8"))

        self.wfile.write(bytes("</body></html><p>", "utf-8"))

class MyServer(threading.Thread):
    def run(self):
        hostName=get_ip()
        print('Start server at: '+str(hostName)+' port='+str(serverPort))
        self.server = ThreadingHTTPServer((hostName, serverPort), MyServer2)
        self.server.serve_forever()
    def stop(self):
        print('Server stopped')
        self.server.shutdown()

def get_ip():
  import netifaces as ni
  x = ni.gateways() 
  y = x['default'][2][1] 
  ip = ni.ifaddresses(y)[ni.AF_INET][0]['addr']
  return ip

def add_web(oval):
    s = MyServer()
    s.start()
    print('thread alive:', s.is_alive())  # True
    return s



err_con=check_conn()
if err_con != None:
  messagebox.showinfo("ERROR", str(err_con)+'\nIP: '+IP_address)
else:
  wnd=setup_gui()
  rt = RepeatedTimer(1, get_val) # it auto-starts, no need of rt.start()

#  wsrv=add_web(eoval)
#  wsrv.stop()
  wnd.mainloop()
  if wsrv!=None:
    wsrv.stop()
  if rt!=None:
    rt.stop() # better in a try/finally block to make sure the program ends!
