########################################################
# Codes etc. for sr1 status monitor
from pysnmp.hlapi import *

IP_address='192.168.178.99'

class sc:
  pre_oid='1.3.6.1.4.1'
  ayecka='27928'
  sr1='101'
  config='1'
  rx1='1'
  rx1_cfg1='1'
  rx1_cfg2='2'
  rx1_cfg1o2='?'
  rx1_cfg_mode='3'
  rx1CfgSet1Status='1'
  rx1CfgSet2Status='2'
  rx1_status='4'
  rx1_cfg1_lnb='3'
  lnbpow='1'

  base_oid_rx1=pre_oid+'.'+ayecka+'.'+sr1+'.'+config+'.'+rx1

  code_config =base_oid_rx1+'.'+rx1_cfg_mode
  code_config1=code_config +'.'+rx1CfgSet1Status
  code_config2=code_config +'.'+rx1CfgSet2Status
  code_status =base_oid_rx1+'.'+rx1_status

noval=' '

def is_integer(n):
  try:
    int(n)
  except:
    return False
  return True

def toint(n):
  if is_integer(n):
    return int(n)
  else:
    return 0

def check_conn():
  iterator = getCmd(
    SnmpEngine(),
    CommunityData('public', mpModel=0),
    UdpTransportTarget((IP_address, 161)),
    ContextData(),
    ObjectType(ObjectIdentity('SNMPv2-MIB', 'sysDescr', 0))
  )
  errorIndication, errorStatus, errorIndex, varBinds = next(iterator)
  return errorIndication

def get_value(cmd):
  iterator = getCmd(
    SnmpEngine(),
    CommunityData('public', mpModel=0),
    UdpTransportTarget((IP_address, 161)),
    ContextData(),
    ObjectType(ObjectIdentity(cmd))
  )
  errorIndication, errorStatus, errorIndex, varBinds = next(iterator)
  if errorIndication!=None:
    return errorIndication

  for varBind in varBinds:
    ln=str(varBind)
    val=ln.split('=')
    return str(val[1])
  return ''

def set_value(cmd,val):
  iterator = setCmd(
    SnmpEngine(),
    CommunityData('public', mpModel=0),
    UdpTransportTarget((IP_address, 161)),
    ContextData(),
    ObjectType(ObjectIdentity(cmd),OctetString(toint(val)))
  )
  errorIndication, errorStatus, errorIndex, varBinds = next(iterator)

def get_config(n=1):
  if n==2:
    cmd=sc.code_config2
  else:
    cmd=sc.code_config1
  return get_value(cmd)

def set_config(n=1,val=0):
  if n==2:
    cmd=sc.code_config2
  else:
    cmd=sc.code_config1
  set_value(cmd,val)

def is_locked(n):
  
  if is_integer(n):
    if int(n):
      return 'Unlocked'
    else:
      return 'Locked'
  else:
    return 'No conn!'

def div10(n):
  if is_integer(n):
    return float(int(n)/10)
  else:
    return 0

def tostr(n):
  return n

def int_or_str(n):
  if is_integer(n):
    return int(n)
  else:
    return n


names_mod=['MODCOD','Linkmrg L','Linkmrg H']

cmdstat=[[sc.rx1_status  +'.1.0'                           ,'Tuner'     ,is_locked],
         [sc.rx1_status  +'.4.0'                           ,'SNR'       ,div10],
         [sc.rx1_cfg1o2  +'.'+sc.rx1_cfg1_lnb+'.'+sc.lnbpow,'LNB'       ,tostr],
         [sc.rx1_status  +'.3.0'                           ,'Power'     ,div10], 
         [sc.rx1_status  +'.7.0'                           ,names_mod[0],tostr], 
         [sc.rx1_status  +'.6.0'                           ,names_mod[1],div10], 
         [sc.rx1_status  +'.6.0'                           ,names_mod[2],div10], 
         [sc.rx1_status  +'.5.0'                           ,'BER'       ,div10], 
         [sc.rx1_status  +'.12.0'                          ,'CRCErr'    ,int_or_str]] 

#cmdconf=[rx1CfgSet1Status,rx1CfgSet2Status]

#      ['2.0','FREQOFFSET'],
#      ['8.0','ROLLOFFSTAT'],
#      ['9.0','PILOTSTAT'],
#      ['10.0','FRAMETYPESTAT'],
#      ['11.0','DEMODSTAT'],
#      ['13.0','TRANSPSTAT'],
#      ['15.0','BADFRMCNT'],
#      ['16.0','BADPCKTCNT']]

def get_stat():
  for n in cmds:
    cmd=code_status+'.'+n[0]
    print(get_value(cmd))
