###########################################################################
# User dependend items
# Hilversum   , 2023/04/01       License GPL3          (c) Rob Alblas
###########################################################################
from os.path import expanduser
import platform
from LEOstuff import toodir as leo_toodir


opsys=platform.system()

#Location where tools and data of satpy are located
home=expanduser("~")
etooldir=home+'/tools/satpy/eSPStools'
tlefil = leo_toodir + '/userconfig/my_TLE_file.txt'

if (opsys=='Linux'):
  Viewer=''
elif (opsys=='Windows'):
  Viewer=''
else:
  sys.exit('Unknown OS: '+opsys)

# max. allowed age in days of tle item (not file age!)
max_tle_age=10

# image earth for polar tracks
earth_image=etooldir+'/earthmap.gif'
#Base command
# May be:
#  'python3 <location_of_script>
# or:
#  '' (asumed is that the script is executable and their location(s) are in the search path
exe_cmd='python3 ' + etooldir + '/'
#exe_cmd=''
#
#################################################################################################################
# 
# Data types from sats and their Python scripts
#
# Version 4 (SPS)
#                id         file filter(s)                              command to use
geosattypes = [['MSG'     ,['H-000-MSG*'                              ],exe_cmd+'MSG.py'      ],
               ['MSGn'    ,['MSG*-SEVI*'                              ],exe_cmd+'MSG.py'      ],
               ['MTG'     ,['W_XX-EUMETSAT-*BODY*'                    ],exe_cmd+'MTI.py'      ],
               ['GOES'    ,['OR_ABI-*'                                ],exe_cmd+'GOES.py'     ],
               ['HIMA'    ,['IMG_DK01*'                               ],exe_cmd+'HIMA.py'     ]]

leosattypes = [['Metop'   ,['AVHR_xxx_1B_M0*'                         ],exe_cmd+'Metop.py'     ],
               ['NOAA'    ,['SV*C_j01_d*'                             ],exe_cmd+'NOAA.py'      ],
               ['SUOMI'   ,['SV*C_npp_d*'                             ],exe_cmd+'NOAA.py'      ],
               ['FY3D'    ,['FY3D*1000M_L1B.HDF','FY3D*GEO1K_L1B.HDF' ],exe_cmd+'FY3D.py'      ],
               ['Aqua'    ,['thin_MYD021KM.A*'                        ],exe_cmd+'AquaTerra.py' ],
               ['Terra'   ,['thin_MOD021KM.A*'                        ],exe_cmd+'AquaTerra.py' ],
               ['Sentinel',['S3*_OL_1_EFR____*','S3*_OL_1_ERR____*'   ],exe_cmd+'Sen3.py' ]]

#################################################################################################################
# Locations of data. Used in satpy_selector only.
# You may adapt (extend, remove, change) items in this table with your own items.
#   The names in column 'sat-ID' are used to link to the same column in the 'composite_list'.
#   The names in column 'data-set' are used to create the Satellite menu but don't have further meaning.
#   'path to data' shows where to find the data.
#
# Common part source location
source_loc='/srv/'
#           sat-ID      data-set    path to data
data_loc=[['MSG',     ['msg'      ,source_loc+'']],
          ['MTG',     ['mtg'      ,source_loc+'']],
          ['GOES',    ['goes'     ,source_loc+'']],
          ['HIMA',    ['hima'     ,source_loc+'']],
          ['METOP',   ['metop'    ,source_loc+'']],
          ['NOAA',    ['noaa'     ,source_loc+'']],
          ['NOAA',    ['suomi'    ,source_loc+'']],
          ['FY3D',    ['fy3d'     ,source_loc+'']],
          ['AQUA',    ['aquaterra',source_loc+'']],
          ['SENTINEL',['sentinel' ,source_loc+'']]]

#################################################################################################################
# List of regios. Used in satpy_selector only.
#   This divides the long area list into smaller chuncks to get a managable menu in satpy_selector.
#   Adapt to your wishes. The area within (lat1,lon1) and (lat2,lon2) is added to regioname 'name'.
#   'name' is used to create the area menu in satpy_selector
#
#             name            lat1,lon1   lat2,lon2
regio_list=[['Arctica'      ,( 65 ,-180),( 90 , 180)],
            ['N europe'     ,( 55 , -20),( 70 ,  40)],
            ['europe'       ,( 32 , -20),( 55 ,  40)],
            ['asia'         ,( -9 ,  56),( 51 , 158)],
            ['africa'       ,(-38 , -25),( 32 ,  48)],
            ['N america'    ,(  4 ,-169),( 70 , -58)],
            ['S america'    ,(-55 , -87),( 15 , -32)],
            ['Antarctica'   ,(-90 ,-180),(-65 , 180)],
            ['Lon -45..+45' ,(None, -45),(None,  45)],
            ['Lon +45..135' ,(None,  45),(None, 135)],
            ['Lon 135..-135',(None, 135),(None,-135)],
            ['Lon -135..-45',(None,-135),(None, -45)],
            ['rest'         ,(-90 ,-180),( 90 , 180)]]

#                 sat-ID      composites
composite_list=[['MSG'    , ['default','natural_color', 'realistic_colors', 'hrv_clouds','natural_enh_with_night_ir_hires']],
                ['MTG'    , ['default','natural_color','true_color','true_color_raw']],
                ['HIMA'   , ['default','natural_color', 'true_color', 'overview', 'airmass', 'colorized_ir_clouds']],
                ['GOES'   , ['default','natural_color', 'true_color', 'overview', 'airmass', 'colorized_ir_clouds','water_vapors1']],
                ['METOP/D', ['default','green_snow', 'ir108_3d', 'ir_cloud_day', 'natural_color', 'natural_color_raw',
                             'natural_enh', 'natural_with_night_fog', 'overview', 'overview_raw']],
                ['METOP/N', ['default',' night_microphysics']],
                ['FY3D'   , ['default','ash', 'cloudtop', 'day_microphysics', 'dust', 'fog', 'green_snow',
                             'ir108_3d','ir_cloud_day', 'natural_color', 'natural_color_lowres',
                             'natural_color_raw', 'natural_with_night_fog', 'night_fog', 'overview',
                             'overview_raw', 'true_color', 'true_color_raw']],
                ['AQUA/D' , ['default','natural_color', 'overview', 'true_color_thin']],
                ['AQUA/N' , ['default','dust', 'ir108_3d', 'night_fog']],

                ['TERRA/D', ['default','natural_color', 'overview', 'true_color_thin']],
                ['TERRA/N', ['default','dust', 'ir108_3d', 'night_fog']],

                ['NOAA/D' , ['default','ash', 'cloudtop_daytime', 'dust', 'false_color', 'fire_temperature',
                             'fire_temperature_39refl', 'fire_temperature_awips', 'fire_temperature_eumetsat',
                             'fog', 'ir108_3d', 'ir_cloud_day', 'natural_color', 'natural_color_sun_lowres',
                             'natural_with_night_fog', 'night_fog', 'ocean_color', 'overview', 'snow_age',
                             'snow_lowres', 'true_color', 'true_color_lowres', 'true_color_lowres_crefl',
                             'true_color_lowres_land', 'true_color_lowres_marine_tropical', 'true_color_raw']],
                ['NOAA/N'  ,['default','adaptive_dnb', 'ash', 'dust', 'dynamic_dnb', 'fog', 'histogram_dnb', 'hncc_dnb',
                              'ir108_3d', 'night_fog', 'night_overview']],

                ['Sentinel',['default','ocean_color', 'true_color', 'true_color_desert', 'true_color_land', 
                             'true_color_marine_clean','true_color_marine_tropical', 'true_color_raw']]]  

overlay_list=[['default',True ],['coasts',False],['boarders',False],['rivers' ,False],['lakes' ,False],
              ['grid'   ,False],['cities',False],['points'  ,False],['station',False],['Legend',False]]
