####################################################################################
# Plotter of tracks in satpy_selector
# Hilversum   , 2023/04/01       License GPL3          (c) Rob Alblas
####################################################################################
from LEOstuff import set_orbit
from datetime import datetime,timedelta
import re
from satpy_areas import get_area_info
from satpy_settings import earth_image

fact=2 #factor degrees to size

def date2str(s):
  return s[:4]+'-'+s[4:6]+'-'+s[6:8]

def time2str(s):
  return s[:2]+':'+s[2:4] # +':'+s[4:6]

# plot track
#   create viewer if not exist and add tracks etc.
def plot_track(satname=None,date1=None,time1=None,date2=None,time2=None,timeset=None,sel_area=None,tlefil='',histtle=False):
  global img # anders img opgeruimd na func!
  if sel_area==None:
    track_viewer(None) # remove track part
    return

  orb=set_orbit(satname,date1[0:4], date1[4:6], date1[6:8],tlefil,use_hist_tle=histtle)
  if orb==None:
    return
  dt1=datetime.strptime(date1+time1,"%Y%m%d%H%M%S")
  dt2=datetime.strptime(date2+time2,"%Y%m%d%H%M%S")
  (cvsx,width,height)=track_viewer(earth_image)
  if cvsx==None:
    return

  step=timedelta(minutes=1)
  ilon0=ilat0=-1000;

  ts1=re.split(r'[{}]',timeset)
  for tsx in ts1:
    if tsx==' ':
      continue
    tsy=re.split(r' ',tsx)
    if len(tsy)!=2:
      continue
    dt1=datetime.strptime(date1+tsy[0],"%Y%m%d%H%M%S")
    dt2=datetime.strptime(date2+tsy[1],"%Y%m%d%H%M%S")
    while dt1 < dt2:
      (slon1, slat1, salt1) = orb.get_lonlatalt(dt1)
      ilon1=int(slon1)
      ilat1=int(slat1)
      ilon1+=180
      ilat1+=90
      ilon1=ilon1*fact
      ilat1=height-1-ilat1*fact
      if (ilon0!=-1000):
        if abs(ilon0-ilon1)<50:
          cvsx.create_line(ilon0, ilat0, ilon1, ilat1,width=1,fill="red")
      ilon0=ilon1;
      ilat0=ilat1;

      dt1+=step
  cvsx.create_text(20,5,text=satname+'  '+date2str(date1)+'  '+time2str(time1)+' - '+time2str(time2),anchor=tk.NW)

  plot_area(cvsx,sel_area,width,height)
  # Plot area selected

  return

from satpy.resample import get_area_def
import pyresample
def plot_area(cvsx,sel_area,width,height):
  selected_area = sel_area.get()
  if selected_area == 'default':
    print('Using default area.')
    return
  try:
    sarea=get_area_def(selected_area)
  except:
    print('No area "'+str(selected_area)+'" found.')
    return

  try:
    arr=pyresample.geometry.BaseDefinition.get_bbox_lonlats(sarea)
  except:
    print("Can't create bbox for "+str(selected_area))
    return

  lons=arr[0]
  lats=arr[1]
  m=0
  for lon in lons:
    lat=lats[m]
    n=0
    for lon1 in lon:
      if abs(lon1) > 1000:
        continue
      lat1=lat[n]
      if abs(lat1) > 1000:
        continue
      ilon=int((lon1+180)*fact)
      ilat=height-1-int((lat1+90)*fact)

      if n>0:
        cvsx.create_line(ilon0, ilat0, ilon, ilat,width=1,fill="blue")
      ilon0=ilon
      ilat0=ilat
      ilon0=ilon
      ilat0=ilat

      n+=1
    m+=1


# Create track viewer with background image and grid
import tkinter as tk
from tkinter import *
from PIL import ImageTk, Image
cvsx=None
frame=None
def track_viewer(fn):
  global img # anders img opgeruimd na func!
  global cvsx
  global frame
  if fn==None:
    if frame:
      frame.destroy()
      frame=None
      cvsx=None
    return

  width=360*fact
  height=180*fact

  # create frame with canvas, or use existing one
  if cvsx==None:
    frame=Frame()
    cvsx = tk.Canvas(frame, bg="grey90", height=height, width=width)
    cvsx.grid()
    frame.pack()

  # clear canvas, then add background image again 
  if cvsx != None:
    cvsx.delete('all')
  try:
    img1=Image.open(fn)
  except:
    if frame:
      frame.destroy()
    frame=None
    cvsx=None

    print(fn+" doesn't exist.")
    return None,None,None

  img1=img1.resize((width,height))
  img = ImageTk.PhotoImage(img1)
  cvsx.create_image(0,0,image=img,anchor="nw")

  # Add lon/lat grid
  step=30 # degrees, lat and lon
  for lat in range(-90+step,90,step):
    cvsx.create_line(0,(lat+90)*fact,360*fact,(lat+90)*fact,width=1)
  for lon in range(0+step,360,step):
    cvsx.create_line(lon*fact,0,lon*fact,180*fact,width=1)

  return cvsx,width,height
