##############################################################
# Area related functions and defs:
#   read from .yaml files
#   calculate ran
#   divide area's in regio's
# Hilversum   , 2022/11/01       License GPL3          (c) Rob Alblas
#
############################################################################################

from satpy_settings import regio_list
import re
import math

class carea:
  def __init__(self):
    self.head=None
    self.next=None
    self.name=None
    self.lat=None
    self.lon=None
    self.ran=None
    self.llx=None
    self.lly=None
    self.urx=None
    self.ury=None
    self.done=False

  def __iter__(self):
    node = self.head
    while node is not None:
        yield node
        node = node.next

class cregio:
  def __init__(self,name=None):
    self.head=None
    self.next=None
    self.name=name
    self.area=carea()
  def __iter__(self):
    node = self.head
    while node is not None:
        yield node
        node = node.next


#######################################################
# Parse related funcs for .yaml-file
#######################################################
# parse .yaml-file: check start-of-area description
def is_new_area(ln):
  sln=ln.split()
  if sln!=[] and sln[0][len(sln[0])-1:] == ':' and ln[0]!=' ':
    return True
  else:
    return False

# start part intended column 2
def is_start2(ln,x):
  y='  '+x+':'
  if ln[:len(y)] ==y:
    return True
  else:
    return False

# end part intended column 2
def is_end2(ln):
  if len(ln)>2 and ln[2]!=' ':
    return True
  else:
    return False

# add new area to 'areas'
def add_area(areas,name,lat=None,lon=None,ran=None,llx=None,lly=None,urx=None,ury=None):
  global parea
  a=carea()
  a.name=name
  a.lat=lat
  a.lon=lon
  a.ran=ran
  a.llx=llx
  a.lly=lly
  a.urx=urx
  a.ury=ury

  if (areas.head==None):
    areas.head=a
  else:
    for p in areas:
      if p.next==None:
        p.next=a
        break
  return a

#Next partly 'stolen' from LEOstuff.py
def arc_dist(lon, lat, clon, clat):
    # Degrees to radian
    dr = math.pi/180.0
    sinlat = math.sin(lat*dr)
    coslat = math.cos(lat*dr)
    # Use Nautical Triangle, return arc distance from center of map (POI) to corners in degrees
    cosarc = sinlat * math.sin(clat*dr) +  \
             coslat * math.cos(clat*dr) * math.cos((lon-clon)*dr)
    return math.acos(cosarc)/dr

def calc_ran(areas):
  dr=math.pi/180.
  for a in areas:
    if a.lat==None or a.lon==None:
      continue

    #Hm, probably not 100% correct...
    w=abs(a.llx-a.urx)
    h=abs(a.lly-a.ury)
    dlat=h/40000000.*360.
    if a.lat<0:
      abslatmin=a.lat+dlat/2
      if abslatmin>0:
        abslatmin=0
    else:
      abslatmin=a.lat-dlat/2
      if abslatmin<0:
        abslatmin=0

    dlon=(w*math.cos(dr*abslatmin))/40000000.*360.

    fac = 1.5
    d1 = fac * arc_dist(a.lon, a.lat, a.lon-dlon/2,a.lat-dlat/2)
    d2 = fac * arc_dist(a.lon, a.lat, a.lon-dlon/2,a.lat+dlat/2)
    d3 = fac * arc_dist(a.lon, a.lat, a.lon+dlon/2,a.lat-dlat/2)
    d4 = fac * arc_dist(a.lon, a.lat, a.lon+dlon/2,a.lat+dlat/2)
    ran1=min(50.0, max(d1, d2, d3, d4, 10.0))
    a.ran=abs(math.ceil(ran1))


# collect all areas from .yaml files
#   Return: 2D-list, [areaname,lat=float,lon=float]
def collect_all_areas():
  from satpy.resample import get_area_file
  from satpy import config
  from satpy_settings import leo_toodir
  config.set(config_path = [leo_toodir + '/userconfig'])
  areafiles=get_area_file()
  areas=carea()

  areaname=None
  lon=None
  lat=None
  ran=None
  llx=None
  lly=None
  urx=None
  ury=None
  nr=0
  for fs in areafiles:         # all area files (.yaml)
    print('  Read areas from '+fs)
    with open(fs) as f:
      projection=False
      area_extent=False
      for line in iter(f.readline,''):           # parse line by line
        ln=line.strip('\n')
        if is_new_area(ln):    # check: start-of-new area
          if areaname != None:
            add_area(areas,areaname,lat,lon,ran,llx,lly,urx,ury)

          projection=False
          area_extent=False
          lon=None
          lat=None
          ln=ln.split(':')
          areaname=ln[0]

          dubbel=False
          for p in areas:
            if p.name == areaname:
              dubbel=True
              break
          if dubbel:
            areaname = None
            continue

        if is_start2(ln,'projection'):
          projection=True
        elif is_end2(ln):
          projection=False

        if is_start2(ln,'area_extent'):
          area_extent=True
        elif is_end2(ln):
          area_extent=False

        if projection: # catch central position
          sln=ln.split()
          # detection pos
          if sln:
            if sln[0]=='lat_0:':
              lat=float(sln[1])
            if sln[0]=='lat_ts:':
              lat=float(sln[1])
            if sln[0]=='lon_0:':
              lon=float(sln[1])

        if area_extent: # catch central position
          sln=re.split(r'[\[\]\s,]+',ln)
          if len(sln) >1:
            if sln[1]=='lower_left_xy:':
              llx=float(sln[2])
              lly=float(sln[3])
            if sln[1]=='upper_right_xy:':
              urx=float(sln[2])
              ury=float(sln[3])

    # Add the last one
    if areaname != None:
      add_area(areas,areaname,lat,lon,ran,llx,lly,urx,ury)

  calc_ran(areas)
  return areas

# lx=None -> True
# la=None -> lx<lb -> True
# lb=None -> lx>la -> True
def degr_insize(lx,la,lb):
  if lx==None:
    return True;
  if lx>180:
    lx=lx-360
  if lb != None:
    if lb<0 :
      if la != None:
        la=(la+360) %360
      lb=(lb+360) %360
      lx=(lx+360) %360
  if ((la==None) or (lx>=la)) and ((lb==None) or (lx<=lb)):
    return True
  return False

def pri_dbg(s):
  dummy=0
#  print(s)

# test if area is in regio
#     return regio if so, or 'None'
#def in_regio(regio_list,regioname,lat,lon):
def in_regio(regio,area):
  rlat1=regio[1][0]
  rlat2=regio[2][0]
  rlon1=regio[1][1]
  rlon2=regio[2][1]

  # Area: Only lon defined
  if area.lon != None and area.lat == None:
    if rlat1==None and rlat2==None:  # no lat in regio_list
      if degr_insize(area.lon,rlon1,rlon2):
        pri_dbg("Found in regio "+str(regio[0])+" : area "+str(area.name)+", lon: "+str(area.lon)+" in "+str(rlon1)+" ... "+str(rlon2))
        return True

  # Area: Only lat defined
  elif area.lat != None and area.lon == None:
    if rlon1==None and rlon2==None:  # no lon in regio_list
      if degr_insize(area.lat,rlat1,rlat2):
        pri_dbg("Found in regio "+str(regio[0])+" : area "+str(area.name)+", lat: "+str(area.lat)+" in "+str(rlat1)+" ... "+str(rlat2))
        return True

  # lat and lon defined
  elif area.lat != None and area.lon != None:
#    if rlat1!=None and rlat2!=None and rlon1!=None and rlon2!=None:  # lat and lon in regio_list
      if degr_insize(area.lat,rlat1,rlat2) and \
         degr_insize(area.lon,rlon1,rlon2): 
        pri_dbg("Found in regio "+str(regio[0])+" : area "+str(area.name)+", lat,lon: ("+str(area.lat)+","+str(area.lon)+") in ("+str(rlat1)+","+str(rlon1)+") ... ("+str(rlat2)+","+str(rlon2)+")")
        return True

  return False # out-of-area

def add_regio(regios,name):
  global pregio
  r=cregio()
  r.name=name

  if (regios.head==None):
    regios.head=r
  else:
    for p in regios:
      if p.next==None:
        p.next=r
        break
  return r

def pri_selregio(r,a):
  print("lat: regio="+str(r[0])+"  area="+str(a.name)+"  lat1="+str(r[1][0])+"  lat="+str(a.lat)+"  lat2="+str(r[2][0]))
  print("lon: regio="+str(r[0])+"  area="+str(a.name)+"  lon1="+str(r[1][1])+"  lon="+str(a.lon)+"  lon2="+str(r[2][1]))
  print("")

# create structured areaset: areas as from *.yaml files 
#    grouped under regio_list:
#   regio1 -> area1a -> area1b.....
#     |
#     V
#   regio2 -> area2a -> area2b.....
#     |
#     V
#   regio3 -> area3a -> area3b.....
#   ....
# return:
def create_regioarea(regio_list,areas):
  regios=cregio()
  parea=None
  r=add_regio(regios,'default')
  add_area(r.area,'default')

  for regio in regio_list:                         # regio=[regiox,(lat1,lon1),(lat2,lon2)]
    r=add_regio(regios,regio[0])
    if regio[0]!='rest':
      for area in areas:
        if not area.done:
          if area.lat!=None or area.lon!=None:
            if in_regio(regio,area): # test area in box of area[0]
              add_area(r.area,area.name,area.lat,area.lon,area.ran)
              area.done=True
    else:
      for area in areas:
        if not area.done:
#          pri_dbg("Not found in any regio: area "+str(area.name)+", lat,lon: ("+str(area.lat)+","+str(area.lon)+")")
          add_area(r.area,area.name,area.lat,area.lon,area.ran)
  return regios

def get_area_info(areaname):
  areas=collect_all_areas()
  for p in areas:
    if p.name==areaname:
      return p
  return None
      

def list_areas(ar):
  for p in ar:
    print(p.name+'  lat='+str(p.lat)+'   lon='+str(p.lon)+'   ran='+str(p.ran)+'   llx='+str(p.llx)+'   lly='+str(p.lly)+'   urx=' +str(p.urx)+'   ury='+str(p.ury))

def list_regios_areas(ra):
  for p in ra:
    print(p.name)
    for q in p.area:
      print('    '+str(q.name)+'  '+str(q.lat)+'   '+str(q.lon)+'   ran='+str(q.ran))

## Example use:
## info one area:
#a=get_area_info('westminster')
#print(str(a.name)+'  lat='+str(a.lat)+'   lon='+str(a.lon)+'   ran='+str(a.ran))

##  extracted info all area's
#a=collect_all_areas()
#list_areas(a)

##  collect area's per regio
#a=collect_all_areas()
#regios=create_regioarea(regio_list,a)
#list_regios_areas(regios)
